/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.srtp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import mil.jfcom.cie.media.srtp.BaseProcessor;
import mil.jfcom.cie.media.srtp.Logging;

public class RTPTransport
implements OutputDataStream,
PushSourceStream {
    private Thread thread;
    protected DatagramPacket receivePacket;
    protected byte[] recvBuf = new byte[2048];
    protected InetAddress remoteAddress;
    protected int remotePort;
    protected DatagramSocket sock;
    boolean active;
    SourceTransferHandler transferHandler;

    public RTPTransport(DatagramSocket localSocket, InetAddress remoteAddress, int remotePort) {
        this.sock = localSocket;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.receivePacket = new DatagramPacket(this.recvBuf, this.recvBuf.length);
    }

    public void close() {
        this.active = false;
        this.thread = null;
        if (this.sock != null) {
            this.sock.close();
        }
        this.receivePacket = null;
    }

    public boolean endOfStream() {
        return false;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return 0L;
    }

    public Object getControl(String arg0) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public int getMinimumTransferSize() {
        return 2048;
    }

    public int read(byte[] data, int offset, int maxLength) {
        int length = this.receivePacket.getLength();
        System.arraycopy(this.receivePacket.getData(), this.receivePacket.getOffset(), data, offset, length);
        return length;
    }

    public void setTransferHandler(SourceTransferHandler handler) {
        this.transferHandler = handler;
    }

    public void start(BaseProcessor sendProcessor, BaseProcessor receiveProcessor) {
        if (!this.active) {
            this.active = true;
            this.thread = new Thread(){

                public void run() {
                    while (RTPTransport.this.active) {
                        try {
                            RTPTransport.this.receivePacket.setData(RTPTransport.this.recvBuf);
                            RTPTransport.this.sock.receive(RTPTransport.this.receivePacket);
                            RTPTransport.this.transferHandler.transferData((PushSourceStream)RTPTransport.this);
                        }
                        catch (SocketException e) {
                            Logging.LOG.debug((Object)"Socket already closed", (Throwable)e);
                            RTPTransport.this.active = false;
                        }
                        catch (IOException e) {
                            Logging.LOG.error((Object)"UDP receive", (Throwable)e);
                        }
                    }
                }
            };
            this.thread.setDaemon(true);
            this.thread.start();
            Logging.LOG.info((Object)"Started : Start sending and receiving data.");
        }
    }

    public int write(byte[] data, int offset, int length) {
        try {
            this.sock.send(new DatagramPacket(data, offset, length, this.remoteAddress, this.remotePort));
            Logging.LOG.info((Object)("Sock Send: " + this.sock.getLocalAddress() + ":" + this.sock.getLocalPort() + ">" + this.remoteAddress + ":" + this.remotePort));
            return length;
        }
        catch (SocketException e) {
            Logging.LOG.debug((Object)"Socket already closed", (Throwable)e);
        }
        catch (IOException e) {
            Logging.LOG.error((Object)"UDP send", (Throwable)e);
        }
        return 0;
    }
}

