/*
 * Decompiled with CFR 0.152.
 */
package mil.jfcom.cie.media.demo;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import javax.media.NoProcessorException;
import javax.media.format.UnsupportedFormatException;
import javax.media.rtp.rtcp.SourceDescription;
import mil.jfcom.cie.media.demo.SimpleEventHandler;
import mil.jfcom.cie.media.session.MediaSession;
import mil.jfcom.cie.media.session.MediaSessionListener;
import mil.jfcom.cie.media.srtp.Logging;
import mil.jfcom.cie.media.srtp.packetizer.SpeexFormat;

public final class AudioTest {
    public static MediaSession createSession(String localhost, int localPort, String remoteHost, int remotePort, MediaSessionListener eventHandler, int quality, boolean secure, boolean micOn) throws NoProcessorException, UnsupportedFormatException, IOException, GeneralSecurityException {
        SpeexFormat.setFramesPerPacket(1);
        byte[] masterKey = new byte[]{-31, -7, 122, 13, 62, 1, -117, -32, -42, 79, -93, 44, 6, -34, 65, 57};
        byte[] masterSalt = new byte[]{14, -58, 117, -83, 73, -118, -2, -21, -74, -106, 11, 58, -85, -26};
        DatagramSocket[] localPorts = MediaSession.getLocalPorts(InetAddress.getByName(localhost), localPort);
        MediaSession session = MediaSession.createInstance(remoteHost, remotePort, localPorts, quality, secure, masterKey, masterSalt);
        session.setListener(eventHandler);
        session.setSourceDescription(new SourceDescription[]{new SourceDescription(2, "Superman", 1, false), new SourceDescription(3, "cdcie.tester@je.jfcom.mil", 1, false), new SourceDescription(5, InetAddress.getByName(localhost) + " Port " + session.getLocalDataPort(), 1, false), new SourceDescription(6, "JFCOM CDCIE Audio Chat", 1, false)});
        Logging.LOG.info((Object)"Starting session...");
        session.start(micOn);
        Logging.LOG.info((Object)"Session started.");
        return session;
    }

    public static void main(String[] args) {
        try {
            AudioTest.testRTPSession("200.233.130.64", 10010, "200.233.130.64", 20005, 120000L, false);
        }
        catch (Exception e) {
            Logging.LOG.error((Object)e);
        }
    }

    public static void testRTPSession(String localhost, int localPort, String remotehost, int remotePort, long duration, boolean secure) {
        try {
            SimpleEventHandler eventHandler = new SimpleEventHandler();
            MediaSession session = AudioTest.createSession(localhost, localPort, remotehost, remotePort, eventHandler, 5, secure, true);
            eventHandler.setSession(session);
            Thread.sleep(duration);
            session.close();
        }
        catch (Exception e) {
            Logging.LOG.error((Object)e);
        }
    }

    private AudioTest() {
    }
}

