/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.messagelog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.backend.roster.JIDStatusGroup;
import nu.fw.jeti.backend.roster.PrimaryJIDStatus;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.plugins.messagelog.MessageLogWindow;

public class IndexOldLogs {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    private static Map map;

    public static void index(final JIDStatus jIDStatus, final MessageLogWindow messageLogWindow, final JIDStatusGroup jIDStatusGroup) {
        map = new HashMap();
        Thread thread = new Thread(){

            public void run() {
                if (jIDStatusGroup != null) {
                    PrimaryJIDStatus primaryJIDStatus = jIDStatusGroup.searchPrimaryJIDStatus(jIDStatus.getNick());
                    IndexOldLogs.parseJIDStatus(primaryJIDStatus.getJIDPrimaryStatus());
                    if (primaryJIDStatus.hasMultiple()) {
                        Iterator iterator = primaryJIDStatus.getOtherJidStatussen();
                        while (iterator.hasNext()) {
                            JIDStatus jIDStatus2 = (JIDStatus)iterator.next();
                            IndexOldLogs.parseJIDStatus(jIDStatus2);
                        }
                    }
                } else {
                    IndexOldLogs.parseJIDStatus(jIDStatus);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        messageLogWindow.addData(map);
                    }
                });
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseJIDStatus(JIDStatus jIDStatus) {
        String string = null;
        string = jIDStatus.getType().equals("unknown") || jIDStatus.getType().equals("jabber") ? jIDStatus.getJID().toStringNoResource() : jIDStatus.getJID().getUser() + "." + jIDStatus.getType();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(Start.path + "logs" + File.separator + string + ".txt"));
            IndexOldLogs.parseLog(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static void parseLog(BufferedReader bufferedReader) throws IOException {
        String string;
        StringBuffer stringBuffer = null;
        Date date = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("")) continue;
            if (string.startsWith("----------------") && string.length() > 50 && string.endsWith("----------------")) {
                String string2 = string.substring(16);
                string2 = string2.substring(0, string2.length() - 16);
                try {
                    Date date2 = dateFormat.parse(string2);
                    if (stringBuffer != null) {
                        map.put(date, stringBuffer.toString());
                    }
                    stringBuffer = new StringBuffer();
                    date = date2;
                }
                catch (ParseException parseException) {
                    stringBuffer.append(string + '\n');
                }
                continue;
            }
            stringBuffer.append(string + '\n');
        }
        map.put(date, stringBuffer.toString());
    }
}

