/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Random;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.NbEncoder;
import org.xiph.speex.OggCrc;
import org.xiph.speex.PcmWaveWriter;
import org.xiph.speex.RawWriter;
import org.xiph.speex.SbEncoder;
import org.xiph.speex.SpeexDecoder;

public class JSpeexDec {
    public static final String VERSION = "Java Speex Command Line Decoder v0.9.7 ($Revision: 1.4 $)";
    public static final String COPYRIGHT = "Copyright (C) 2002-2004 Wimba S.A.";
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int WARN = 2;
    public static final int ERROR = 3;
    protected int printlevel = 1;
    public static final int FILE_FORMAT_RAW = 0;
    public static final int FILE_FORMAT_OGG = 1;
    public static final int FILE_FORMAT_WAVE = 2;
    protected int srcFormat = 1;
    protected int destFormat = 2;
    protected static Random random = new Random();
    protected SpeexDecoder speexDecoder;
    protected boolean enhanced = true;
    private int mode = 0;
    private int quality = 8;
    private int nframes = 1;
    private int sampleRate = -1;
    private float vbr_quality = -1.0f;
    private boolean vbr = false;
    private int channels = 1;
    private int loss = 0;
    protected String srcFile;
    protected String destFile;

    public static void main(String[] stringArray) throws IOException {
        JSpeexDec jSpeexDec = new JSpeexDec();
        if (jSpeexDec.parseArgs(stringArray)) {
            jSpeexDec.decode();
        }
    }

    public boolean parseArgs(String[] stringArray) {
        if (stringArray.length < 2) {
            if (stringArray.length == 1 && (stringArray[0].equals("-v") || stringArray[0].equals("--version"))) {
                JSpeexDec.version();
                return false;
            }
            JSpeexDec.usage();
            return false;
        }
        this.srcFile = stringArray[stringArray.length - 2];
        this.destFile = stringArray[stringArray.length - 1];
        this.srcFormat = this.srcFile.toLowerCase().endsWith(".spx") ? 1 : (this.srcFile.toLowerCase().endsWith(".wav") ? 2 : 0);
        this.destFormat = this.destFile.toLowerCase().endsWith(".wav") ? 2 : 0;
        for (int i = 0; i < stringArray.length - 2; ++i) {
            if (stringArray[i].equalsIgnoreCase("-h") || stringArray[i].equalsIgnoreCase("--help")) {
                JSpeexDec.usage();
                return false;
            }
            if (stringArray[i].equalsIgnoreCase("-v") || stringArray[i].equalsIgnoreCase("--version")) {
                JSpeexDec.version();
                return false;
            }
            if (stringArray[i].equalsIgnoreCase("--verbose")) {
                this.printlevel = 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--quiet")) {
                this.printlevel = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--enh")) {
                this.enhanced = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--no-enh")) {
                this.enhanced = false;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--packet-loss")) {
                try {
                    this.loss = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (stringArray[i].equalsIgnoreCase("-n") || stringArray[i].equalsIgnoreCase("-nb") || stringArray[i].equalsIgnoreCase("--narrowband")) {
                this.mode = 0;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-w") || stringArray[i].equalsIgnoreCase("-wb") || stringArray[i].equalsIgnoreCase("--wideband")) {
                this.mode = 1;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-u") || stringArray[i].equalsIgnoreCase("-uwb") || stringArray[i].equalsIgnoreCase("--ultra-wideband")) {
                this.mode = 2;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-q") || stringArray[i].equalsIgnoreCase("--quality")) {
                try {
                    this.vbr_quality = Float.parseFloat(stringArray[++i]);
                    this.quality = (int)this.vbr_quality;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--nframes")) {
                try {
                    this.nframes = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JSpeexDec.usage();
                    return false;
                }
            }
            if (stringArray[i].equalsIgnoreCase("--vbr")) {
                this.vbr = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("--stereo")) {
                this.channels = 2;
                continue;
            }
            JSpeexDec.usage();
            return false;
        }
        if (this.sampleRate < 0) {
            switch (this.mode) {
                case 0: {
                    this.sampleRate = 8000;
                    break;
                }
                case 1: {
                    this.sampleRate = 16000;
                    break;
                }
                case 2: {
                    this.sampleRate = 32000;
                    break;
                }
                default: {
                    this.sampleRate = 8000;
                }
            }
        }
        return true;
    }

    public static void usage() {
        JSpeexDec.version();
        System.out.println("Usage: JSpeexDec [options] input_file output_file");
        System.out.println("Where:");
        System.out.println("  input_file can be:");
        System.out.println("    filename.spx  an Ogg Speex file");
        System.out.println("    filename.wav  a Wave Speex file (beta!!!)");
        System.out.println("    filename.*    a raw Speex file");
        System.out.println("  output_file can be:");
        System.out.println("    filename.wav  a PCM wav file");
        System.out.println("    filename.*    a raw PCM file (any extension other than .wav)");
        System.out.println("Options: -h, --help     This help");
        System.out.println("         -v, --version    Version information");
        System.out.println("         --verbose        Print detailed information");
        System.out.println("         --quiet          Print minimal information");
        System.out.println("         --enh            Enable perceptual enhancement (default)");
        System.out.println("         --no-enh         Disable perceptual enhancement");
        System.out.println("         --packet-loss n  Simulate n % random packet loss");
        System.out.println("         if the input file is raw Speex (not Ogg Speex)");
        System.out.println("         -n, -nb          Narrowband (8kHz)");
        System.out.println("         -w, -wb          Wideband (16kHz)");
        System.out.println("         -u, -uwb         Ultra-Wideband (32kHz)");
        System.out.println("         --quality n      Encoding quality (0-10) default 8");
        System.out.println("         --nframes n      Number of frames per Ogg packet, default 1");
        System.out.println("         --vbr            Enable varible bit-rate (VBR)");
        System.out.println("         --stereo         Consider input as stereo");
        System.out.println("More information is available from: http://jspeex.sourceforge.net/");
        System.out.println("This code is a Java port of the Speex codec: http://www.speex.org/");
    }

    public static void version() {
        System.out.println(VERSION);
        System.out.println("using Java Speex Decoder v0.9.7 ($Revision: 1.4 $)");
        System.out.println(COPYRIGHT);
    }

    public void decode() throws IOException {
        this.decode(new File(this.srcFile), new File(this.destFile));
    }

    public void decode(File file, File file2) throws IOException {
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[65536];
        byte[] byArray3 = new byte[176400];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.printlevel <= 1) {
            JSpeexDec.version();
        }
        if (this.printlevel <= 0) {
            System.out.println("");
        }
        if (this.printlevel <= 0) {
            System.out.println("Input File: " + file);
        }
        this.speexDecoder = new SpeexDecoder();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        AudioFileWriter audioFileWriter = null;
        try {
            while (true) {
                int n6;
                if (this.srcFormat == 1) {
                    dataInputStream.readFully(byArray, 0, 27);
                    int n7 = JSpeexDec.readInt(byArray, 22);
                    byArray[22] = 0;
                    byArray[23] = 0;
                    byArray[24] = 0;
                    byArray[25] = 0;
                    int n8 = OggCrc.checksum(0, byArray, 0, 27);
                    if (!"OggS".equals(new String(byArray, 0, 4))) {
                        System.err.println("missing ogg id!");
                        return;
                    }
                    n = byArray[26] & 0xFF;
                    dataInputStream.readFully(byArray, 27, n);
                    n8 = OggCrc.checksum(n8, byArray, 27, n);
                    for (n2 = 0; n2 < n; ++n2) {
                        int n9;
                        n3 = byArray[27 + n2] & 0xFF;
                        if (n3 == 255) {
                            System.err.println("sorry, don't handle 255 sizes!");
                            return;
                        }
                        dataInputStream.readFully(byArray2, 0, n3);
                        n8 = OggCrc.checksum(n8, byArray2, 0, n3);
                        if (n5 == 0) {
                            if (this.readSpeexHeader(byArray2, 0, n3)) {
                                if (this.printlevel <= 0) {
                                    System.out.println("File Format: Ogg Speex");
                                    System.out.println("Sample Rate: " + this.sampleRate);
                                    System.out.println("Channels: " + this.channels);
                                    System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                                    System.out.println("Frames per packet: " + this.nframes);
                                }
                                if (this.destFormat == 2) {
                                    audioFileWriter = new PcmWaveWriter(this.speexDecoder.getSampleRate(), this.speexDecoder.getChannels());
                                    if (this.printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + file2);
                                        System.out.println("File Format: PCM Wave");
                                        System.out.println("Perceptual Enhancement: " + this.enhanced);
                                    }
                                } else {
                                    audioFileWriter = new RawWriter();
                                    if (this.printlevel <= 0) {
                                        System.out.println("");
                                        System.out.println("Output File: " + file2);
                                        System.out.println("File Format: Raw Audio");
                                        System.out.println("Perceptual Enhancement: " + this.enhanced);
                                    }
                                }
                                audioFileWriter.open(file2);
                                audioFileWriter.writeHeader(null);
                                ++n5;
                                continue;
                            }
                            n5 = 0;
                            continue;
                        }
                        if (n5 == 1) {
                            ++n5;
                            continue;
                        }
                        if (this.loss > 0 && random.nextInt(100) < this.loss) {
                            this.speexDecoder.processData(null, 0, n3);
                            for (n9 = 1; n9 < this.nframes; ++n9) {
                                this.speexDecoder.processData(true);
                            }
                        } else {
                            this.speexDecoder.processData(byArray2, 0, n3);
                            for (n9 = 1; n9 < this.nframes; ++n9) {
                                this.speexDecoder.processData(false);
                            }
                        }
                        if ((n4 = this.speexDecoder.getProcessedData(byArray3, 0)) > 0) {
                            audioFileWriter.writePacket(byArray3, 0, n4);
                        }
                        ++n5;
                    }
                    if (n8 == n7) continue;
                    throw new IOException("Ogg CheckSums do not match");
                }
                if (n5 == 0) {
                    if (this.srcFormat == 2) {
                        dataInputStream.readFully(byArray, 0, 12);
                        if (!"RIFF".equals(new String(byArray, 0, 4)) && !"WAVE".equals(new String(byArray, 8, 4))) {
                            System.err.println("Not a WAVE file");
                            return;
                        }
                        dataInputStream.readFully(byArray, 0, 8);
                        String string = new String(byArray, 0, 4);
                        int n10 = JSpeexDec.readInt(byArray, 4);
                        while (!string.equals("data")) {
                            dataInputStream.readFully(byArray, 0, n10);
                            if (string.equals("fmt ")) {
                                if (JSpeexDec.readShort(byArray, 0) != -24311) {
                                    System.err.println("Not a Wave Speex file");
                                    return;
                                }
                                this.channels = JSpeexDec.readShort(byArray, 2);
                                this.sampleRate = JSpeexDec.readInt(byArray, 4);
                                n3 = JSpeexDec.readShort(byArray, 12);
                                if (JSpeexDec.readShort(byArray, 16) < 82) {
                                    System.err.println("Possibly corrupt Speex Wave file.");
                                    return;
                                }
                                this.readSpeexHeader(byArray, 20, 80);
                                if (this.printlevel <= 0) {
                                    System.out.println("File Format: Wave Speex");
                                    System.out.println("Sample Rate: " + this.sampleRate);
                                    System.out.println("Channels: " + this.channels);
                                    System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                                    System.out.println("Frames per packet: " + this.nframes);
                                }
                            }
                            dataInputStream.readFully(byArray, 0, 8);
                            string = new String(byArray, 0, 4);
                            n10 = JSpeexDec.readInt(byArray, 4);
                        }
                        if (this.printlevel <= 0) {
                            System.out.println("Data size: " + n10);
                        }
                    } else {
                        if (this.printlevel <= 0) {
                            System.out.println("File Format: Raw Speex");
                            System.out.println("Sample Rate: " + this.sampleRate);
                            System.out.println("Channels: " + this.channels);
                            System.out.println("Encoder mode: " + (this.mode == 0 ? "Narrowband" : (this.mode == 1 ? "Wideband" : "UltraWideband")));
                            System.out.println("Frames per packet: " + this.nframes);
                        }
                        this.speexDecoder.init(this.mode, this.sampleRate, this.channels, this.enhanced);
                        if (!this.vbr) {
                            switch (this.mode) {
                                case 0: {
                                    n3 = NbEncoder.NB_FRAME_SIZE[NbEncoder.NB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                case 1: {
                                    n3 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.quality]];
                                    n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                case 2: {
                                    n3 = SbEncoder.NB_FRAME_SIZE[SbEncoder.NB_QUALITY_MAP[this.quality]];
                                    n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.WB_QUALITY_MAP[this.quality]];
                                    n3 += SbEncoder.SB_FRAME_SIZE[SbEncoder.UWB_QUALITY_MAP[this.quality]];
                                    break;
                                }
                                default: {
                                    throw new IOException("Illegal mode encoundered.");
                                }
                            }
                            n3 = n3 + 7 >> 3;
                        } else {
                            n3 = 0;
                        }
                    }
                    if (this.destFormat == 2) {
                        audioFileWriter = new PcmWaveWriter(this.sampleRate, this.channels);
                        if (this.printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + file2);
                            System.out.println("File Format: PCM Wave");
                            System.out.println("Perceptual Enhancement: " + this.enhanced);
                        }
                    } else {
                        audioFileWriter = new RawWriter();
                        if (this.printlevel <= 0) {
                            System.out.println("");
                            System.out.println("Output File: " + file2);
                            System.out.println("File Format: Raw Audio");
                            System.out.println("Perceptual Enhancement: " + this.enhanced);
                        }
                    }
                    audioFileWriter.open(file2);
                    audioFileWriter.writeHeader(null);
                    ++n5;
                    continue;
                }
                dataInputStream.readFully(byArray2, 0, n3);
                if (this.loss > 0 && random.nextInt(100) < this.loss) {
                    this.speexDecoder.processData(null, 0, n3);
                    for (n6 = 1; n6 < this.nframes; ++n6) {
                        this.speexDecoder.processData(true);
                    }
                } else {
                    this.speexDecoder.processData(byArray2, 0, n3);
                    for (n6 = 1; n6 < this.nframes; ++n6) {
                        this.speexDecoder.processData(false);
                    }
                }
                if ((n4 = this.speexDecoder.getProcessedData(byArray3, 0)) > 0) {
                    audioFileWriter.writePacket(byArray3, 0, n4);
                }
                ++n5;
            }
        }
        catch (EOFException eOFException) {
            audioFileWriter.close();
            return;
        }
    }

    private boolean readSpeexHeader(byte[] byArray, int n, int n2) {
        if (n2 != 80) {
            System.out.println("Oooops");
            return false;
        }
        if (!"Speex   ".equals(new String(byArray, n, 8))) {
            return false;
        }
        this.mode = byArray[40 + n] & 0xFF;
        this.sampleRate = JSpeexDec.readInt(byArray, n + 36);
        this.channels = JSpeexDec.readInt(byArray, n + 48);
        this.nframes = JSpeexDec.readInt(byArray, n + 64);
        return this.speexDecoder.init(this.mode, this.sampleRate, this.channels, this.enhanced);
    }

    protected static int readInt(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    protected static int readShort(byte[] byArray, int n) {
        return byArray[n] & 0xFF | byArray[n + 1] << 8;
    }
}

