/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui.login;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import nu.fw.jeti.backend.LoginInfo;
import nu.fw.jeti.images.StatusIcons;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.ui.LoginStatusWindow;
import nu.fw.jeti.ui.login.EditProfileWindow;
import nu.fw.jeti.ui.login.ProfileInfo;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class LoginWindow
extends JFrame {
    private JPasswordField txtPassword = new JPasswordField();
    private Backend backend;
    private JComboBox cmbProfile;
    private JPanel jPanel1 = new JPanel();
    private JButton btnEdit = new JButton();
    private JButton btnLogin = new JButton();
    private JButton btnNew = new JButton();
    private ProfileInfo profileInfo = new ProfileInfo();
    private static LoginWindow loginWindow;

    public LoginWindow(Backend backend, String string) {
        this(backend);
        this.getContentPane().add(new JLabel(string));
        this.pack();
    }

    private LoginWindow(Backend backend) {
        this.cmbProfile = new JComboBox<Object>(this.profileInfo.getProfilesList());
        this.backend = backend;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.txtPassword.requestFocus();
    }

    public static void createLoginWindow(Backend backend) {
        if (loginWindow == null) {
            loginWindow = new LoginWindow(backend);
        }
        loginWindow.setVisible(true);
    }

    private void jbInit() throws Exception {
        Object object;
        this.getRootPane().setDefaultButton(this.btnLogin);
        this.setIconImage(StatusIcons.getImageIcon("jeti").getImage());
        this.setTitle(I18N.gettext("main.login.Login"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setCursor(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoginWindow.this.dispose();
                LoginWindow.loginWindow = null;
            }
        });
        this.setResizable(false);
        this.cmbProfile.setAlignmentX(0.0f);
        String string = Preferences.getString("jeti", "profileName", null);
        if (string != null && (object = this.profileInfo.getProfile(string)) != null) {
            this.cmbProfile.setSelectedItem(string);
            if (((LoginInfo)object).getPassword() == null) {
                this.txtPassword.setEditable(true);
            } else {
                this.txtPassword.setEditable(false);
            }
        }
        this.cmbProfile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                LoginInfo loginInfo = LoginWindow.this.profileInfo.getProfile(string);
                if (loginInfo != null) {
                    if (loginInfo.getPassword() == null) {
                        LoginWindow.this.txtPassword.setEditable(true);
                    } else {
                        LoginWindow.this.txtPassword.setEditable(false);
                    }
                }
            }
        });
        I18N.setTextAndMnemonic("main.login.Edit", this.btnEdit);
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.this.btnEdit_actionPerformed(actionEvent);
            }
        });
        I18N.setTextAndMnemonic("main.login.Login", this.btnLogin);
        this.btnLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.this.btnLogin_actionPerformed(actionEvent);
            }
        });
        this.txtPassword.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    LoginWindow.this.btnLogin.doClick();
                }
            }
        });
        this.jPanel1.setAlignmentX(0.0f);
        I18N.setTextAndMnemonic("main.login.New", this.btnNew);
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LoginWindow.this.btnNew_actionPerformed(actionEvent);
            }
        });
        object = new JLabel();
        I18N.setTextAndMnemonic("main.login.Profile", (JLabel)object);
        this.getContentPane().add((Component)object);
        ((JLabel)object).setLabelFor(this.cmbProfile);
        this.getContentPane().add(this.cmbProfile);
        object = new JLabel();
        I18N.setTextAndMnemonic("main.login.Password", (JLabel)object);
        ((JLabel)object).setLabelFor(this.txtPassword);
        this.getContentPane().add((Component)object);
        this.getContentPane().add(this.txtPassword);
        this.getContentPane().add(this.jPanel1);
        this.jPanel1.add((Component)this.btnLogin, null);
        this.jPanel1.add((Component)this.btnEdit, null);
        this.jPanel1.add((Component)this.btnNew, null);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void update() {
        this.cmbProfile.setModel(new DefaultComboBoxModel<Object>(this.profileInfo.getProfilesList()));
    }

    void btnNew_actionPerformed(ActionEvent actionEvent) {
        new EditProfileWindow(this, this.profileInfo, this.backend).setVisible(true);
    }

    void btnEdit_actionPerformed(ActionEvent actionEvent) {
        new EditProfileWindow(this, this.profileInfo, (String)this.cmbProfile.getSelectedItem()).setVisible(true);
    }

    void btnLogin_actionPerformed(ActionEvent actionEvent) {
        if (!this.txtPassword.isEditable() || !this.txtPassword.getText().equals("")) {
            String string = (String)this.cmbProfile.getSelectedItem();
            LoginInfo loginInfo = this.profileInfo.getProfile(string);
            if (loginInfo == null) {
                return;
            }
            if (loginInfo.getPassword() == null) {
                loginInfo.setPassword(this.txtPassword.getText());
            }
            new LoginStatusWindow(loginInfo, this.backend, 1);
            Preferences.putString("jeti", "profileName", string);
            loginWindow = null;
            this.dispose();
        }
    }
}

