/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.InfoQueryBuilder;
import nu.fw.jeti.jabber.elements.Presence;
import nu.fw.jeti.jabber.elements.RosterBuilder;
import nu.fw.jeti.jabber.elements.RosterItemBuilder;
import nu.fw.jeti.ui.JIDInput;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Utils;

public class AddContact
extends JDialog {
    private Box panel1 = Box.createVerticalBox();
    private JLabel jLabel2 = new JLabel();
    private JTextField txtNick = new JTextField();
    private JLabel jLabel3 = new JLabel();
    private JComboBox cmbGroup;
    private JPanel jPanel1 = new JPanel();
    private JButton btnCancel = new JButton();
    private JButton btnOK = new JButton();
    private Backend backend;
    private JIDInput jidInput;

    public AddContact(Backend backend) {
        super(backend.getMainFrame(), I18N.gettext("main.AddContact.Add_Contact"), false);
        this.backend = backend;
        this.jidInput = new JIDInput(backend);
        this.jbInit();
        this.pack();
        this.setLocationRelativeTo(backend.getMainFrame());
    }

    public AddContact(JID jID, String string, String string2, Backend backend) {
        super(backend.getMainFrame(), I18N.gettext("main.AddContact.Add_Contact"), false);
        this.backend = backend;
        this.jidInput = new JIDInput(jID, backend);
        this.txtNick.setText(string);
        this.jbInit();
        if (string2 != null) {
            this.cmbGroup.setSelectedItem(string2);
        }
        this.pack();
        this.setLocationRelativeTo(backend.getMainFrame());
    }

    public AddContact(JID jID, JFrame jFrame, Backend backend) {
        super(jFrame, I18N.gettext("main.AddContact.Add_Contact"), false);
        this.backend = backend;
        this.jidInput = new JIDInput(jID, backend);
        this.jbInit();
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    void jbInit() {
        String[] stringArray = this.backend.getAllGroups();
        if (stringArray.length == 0) {
            stringArray = new String[]{I18N.gettext("main.main.roster.Friends")};
        }
        this.getRootPane().setDefaultButton(this.btnOK);
        this.txtNick.setHorizontalAlignment(2);
        this.cmbGroup = new JComboBox<String>(stringArray);
        this.cmbGroup.setAlignmentX(0.0f);
        this.cmbGroup.setEditable(true);
        this.jPanel1.setAlignmentX(0.0f);
        this.setDefaultCloseOperation(2);
        this.panel1.add(Box.createHorizontalGlue());
        I18N.setTextAndMnemonic("main.AddContact.Nickname", this.jLabel2);
        this.jLabel2.setLabelFor(this.txtNick);
        this.jLabel3.setHorizontalAlignment(2);
        I18N.setTextAndMnemonic("main.AddContact.Group", this.jLabel3);
        this.jLabel3.setLabelFor(this.cmbGroup);
        AbstractAction abstractAction = new AbstractAction(I18N.gettext("Cancel")){

            public void actionPerformed(ActionEvent actionEvent) {
                AddContact.this.dispose();
            }
        };
        Utils.addCancelButton(this, this.btnCancel, abstractAction);
        this.btnOK.setText(I18N.gettext("OK"));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddContact.this.btnOK_actionPerformed(actionEvent);
            }
        });
        this.jidInput.setAlignmentX(0.0f);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add(this.jidInput);
        this.panel1.add(this.jLabel2);
        this.panel1.add(this.txtNick);
        this.panel1.add(this.jLabel3);
        this.panel1.add(this.cmbGroup);
        this.panel1.add(this.jPanel1);
        this.jPanel1.add(this.btnOK);
        this.jPanel1.add(this.btnCancel);
    }

    void btnOK_actionPerformed(ActionEvent actionEvent) {
        JID jID = this.jidInput.createJID();
        if (jID == null) {
            return;
        }
        this.backend.send(new Presence(jID, "subscribe"));
        try {
            String string = this.txtNick.getText();
            if (string.equals("")) {
                string = jID.getUser();
            }
            if (string == null) {
                string = jID.getDomain();
            }
            RosterBuilder rosterBuilder = new RosterBuilder();
            RosterItemBuilder rosterItemBuilder = new RosterItemBuilder();
            rosterItemBuilder.addGroup((String)this.cmbGroup.getSelectedItem());
            rosterItemBuilder.jid = jID;
            rosterItemBuilder.name = string;
            rosterItemBuilder.ask = "subscribe";
            rosterBuilder.addItem(rosterItemBuilder.build());
            InfoQueryBuilder infoQueryBuilder = new InfoQueryBuilder();
            infoQueryBuilder.addExtension(rosterBuilder.build());
            infoQueryBuilder.setType("set");
            this.backend.send(infoQueryBuilder.build());
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        this.dispose();
    }
}

