/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.Iterator;
import java.util.LinkedList;
import nu.fw.jeti.backend.XMLData;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.PacketBuilder;
import nu.fw.jeti.jabber.elements.XMPPError;
import nu.fw.jeti.jabber.elements.XMPPErrorTag;
import nu.fw.jeti.util.I18N;

public abstract class Packet
extends XMLData {
    private JID to;
    private JID from;
    protected String id;
    private int errorCode;
    private String errorDescription;
    private XMPPError xmppError;
    private LinkedList extensions;

    public Packet() {
    }

    public Packet(JID jID) {
        this.to = jID;
    }

    public Packet(Extension extension) {
        if (extension != null) {
            this.extensions = new LinkedList();
            this.extensions.add(extension);
        }
    }

    public Packet(JID jID, Extension extension) {
        this(extension);
        this.to = jID;
    }

    public Packet(JID jID, String string, Extension extension) {
        this(jID);
        this.id = string;
        if (extension != null) {
            this.extensions = new LinkedList();
            this.extensions.add(extension);
        }
    }

    public Packet(JID jID, String string, String string2, int n) {
        this(jID);
        this.id = string;
        this.errorDescription = string2;
        this.errorCode = n;
    }

    public Packet(JID jID, String string, XMPPError xMPPError) {
        this(jID);
        this.id = string;
        this.xmppError = xMPPError;
    }

    protected Packet(PacketBuilder packetBuilder) {
        this.to = packetBuilder.to;
        this.from = packetBuilder.from;
        this.id = packetBuilder.id;
        this.errorCode = packetBuilder.errorCode;
        this.errorDescription = packetBuilder.errorDescription;
        this.extensions = packetBuilder.getExtensions();
        this.xmppError = packetBuilder.xmppError;
    }

    public IQExtension getIQExtension() {
        if (this.extensions == null) {
            return null;
        }
        return (IQExtension)this.extensions.getFirst();
    }

    public XMPPError getXMPPError() {
        return this.xmppError;
    }

    public Iterator getExtensions() {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.iterator();
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public String getID() {
        return this.id;
    }

    public JID getTo() {
        return this.to;
    }

    public JID getFrom() {
        return this.from;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        if (this.xmppError != null && this.errorDescription.length() == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.xmppError.getXMPPErrors();
            while (iterator.hasNext()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                XMPPErrorTag xMPPErrorTag = (XMPPErrorTag)iterator.next();
                stringBuffer.append(I18N.gettext("main.error.xmpp." + xMPPErrorTag.getError()));
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return I18N.gettext("main.error.Unknown_error");
        }
        return this.errorDescription;
    }

    protected void appendBaseAttributes(StringBuffer stringBuffer) {
        Packet.appendAttribute(stringBuffer, "to", this.to);
        Packet.appendAttribute(stringBuffer, "from", this.from);
        Packet.appendAttribute(stringBuffer, "id", this.id);
    }

    protected void appendError(StringBuffer stringBuffer) {
        if (this.xmppError == null) {
            stringBuffer.append("<error");
            Packet.appendAttribute(stringBuffer, "code", String.valueOf(this.errorCode));
            if (this.errorDescription == null) {
                stringBuffer.append("/>");
                return;
            }
            stringBuffer.append(">");
            Packet.escapeString(stringBuffer, this.errorDescription);
            stringBuffer.append("</error>");
        } else {
            this.xmppError.appendToXML(stringBuffer);
        }
    }

    protected void appendExtensions(StringBuffer stringBuffer) {
        if (this.extensions != null) {
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                ((Extension)iterator.next()).appendToXML(stringBuffer);
            }
        }
    }
}

