/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.jabber.elements;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.elements.DiscoveryInfo;
import nu.fw.jeti.jabber.elements.DiscoveryItem;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQBrowseBuilder;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;

public class IQBrowse
extends Extension
implements IQExtension,
DiscoveryItem,
DiscoveryInfo {
    private List namespaces;
    private String name;
    private String type;
    private String category;
    private String version;
    private JID jid;
    private List childItems;

    public IQBrowse() {
    }

    public IQBrowse(JID jID) {
        this.jid = jID;
    }

    public IQBrowse(IQBrowseBuilder iQBrowseBuilder) {
        this.name = iQBrowseBuilder.getName();
        this.jid = iQBrowseBuilder.getJID();
        this.category = iQBrowseBuilder.getCategory();
        this.type = iQBrowseBuilder.getType();
        this.version = iQBrowseBuilder.getVersion();
        this.namespaces = iQBrowseBuilder.getNamespaces();
        this.childItems = iQBrowseBuilder.getItems();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getCategory() {
        return this.category;
    }

    public JID getJID() {
        return this.jid;
    }

    public Iterator getItems() {
        if (this.childItems == null) {
            return null;
        }
        return this.childItems.iterator();
    }

    public int getSize() {
        if (this.childItems == null) {
            return 0;
        }
        return this.childItems.size();
    }

    public boolean hasItems() {
        return this.childItems != null;
    }

    public List getFeatures() {
        if (this.namespaces == null) {
            this.namespaces = new LinkedList();
        }
        return Collections.unmodifiableList(this.namespaces);
    }

    public boolean hasFeatures() {
        return this.namespaces != null;
    }

    public void appendToXMLNoIQ(StringBuffer stringBuffer) {
        stringBuffer.append("<item");
        this.toXML(stringBuffer);
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
    }

    public void appendToXML(StringBuffer stringBuffer) {
        stringBuffer.append("<item xmlns='jabber:iq:browse'");
        this.toXML(stringBuffer);
    }

    private void toXML(StringBuffer stringBuffer) {
        Iterator iterator;
        IQBrowse.appendAttribute(stringBuffer, "jid", this.jid);
        IQBrowse.appendAttribute(stringBuffer, "category", this.category);
        IQBrowse.appendAttribute(stringBuffer, "type", this.type);
        IQBrowse.appendAttribute(stringBuffer, "name", this.name);
        IQBrowse.appendAttribute(stringBuffer, "version", this.version);
        if (this.namespaces == null && this.childItems == null) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        if (this.namespaces != null) {
            iterator = this.namespaces.iterator();
            while (iterator.hasNext()) {
                IQBrowse.appendElement(stringBuffer, "ns", iterator.next());
            }
        }
        if (this.childItems != null) {
            iterator = this.childItems.iterator();
            while (iterator.hasNext()) {
                ((IQBrowse)iterator.next()).appendToXMLNoIQ(stringBuffer);
            }
        }
        stringBuffer.append("</item>");
    }
}

