/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.windowsutils;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.NativeUtils;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.windowsutils.WindowUtil;
import nu.fw.jeti.ui.ChatSplitPane;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
NativeUtils {
    public static final String VERSION = "0.2";
    public static final String DESCRIPTION = "windowsutils.Provides_always_on_top,_transparency_and_flashing_windows";
    public static final String MIN_JETI_VERSION = "0.5.3";
    public static final String NAME = "windowsutils";
    public static final String ABOUT = "by E.S. de Boer";
    private static WindowUtil util;
    private static JMenuItem menuAlwaysOnTop;
    private static JMenuItem menuTransparent;

    public static void init(final Backend backend) {
        System.setProperty("sun.java2d.noddraw", String.valueOf(Preferences.getBoolean((String)NAME, (String)"ddraw", (boolean)true)));
        util = new WindowUtil();
        menuAlwaysOnTop = new JMenuItem(I18N.gettext((String)"windowsutils.Set_Always_On_Top"));
        menuAlwaysOnTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (menuAlwaysOnTop.getText().equals(I18N.gettext((String)"windowsutils.Set_Always_On_Top"))) {
                    menuAlwaysOnTop.setText(I18N.gettext((String)"windowsutils.Not_Always_On_Top"));
                    util.windowAlwaysOnTop(backend.getMainWindow(), true);
                } else {
                    menuAlwaysOnTop.setText(I18N.gettext((String)"windowsutils.Set_Always_On_Top"));
                    util.windowAlwaysOnTop(backend.getMainWindow(), false);
                }
            }
        });
        backend.getMain().addToMenu(menuAlwaysOnTop);
        if (Plugin.is2000orGreater()) {
            menuTransparent = new JMenuItem(I18N.gettext((String)"windowsutils.Make_transparent"));
            menuTransparent.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (menuTransparent.getText().equals(I18N.gettext((String)"windowsutils.Make_transparent"))) {
                        menuTransparent.setText(I18N.gettext((String)"windowsutils.Make_opaque"));
                        util.setWindowAlpha(backend.getMainWindow(), Preferences.getInteger((String)Plugin.NAME, (String)"alpha", (int)70));
                    } else {
                        menuTransparent.setText(I18N.gettext((String)"windowsutils.Make_transparent"));
                        util.setWindowAlpha(backend.getMainWindow(), 100);
                    }
                }
            });
            backend.getMain().addToMenu(menuTransparent);
        }
    }

    private static boolean is2000orGreater() {
        String string = System.getProperty("os.name");
        return string.equals("Windows 2000") || string.equals("Windows 2000") || string.equals("Windows XP") || string.equals("Windows 2003");
    }

    public boolean supportsAlpha() {
        return Plugin.is2000orGreater();
    }

    public void addChatMenus(JMenu jMenu, final ChatSplitPane chatSplitPane) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(I18N.gettext((String)"windowsutils.Set_Always_On_Top"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                    util.windowAlwaysOnTop(chatSplitPane.getTopLevelAncestor(), true);
                } else {
                    util.windowAlwaysOnTop(chatSplitPane.getTopLevelAncestor(), false);
                }
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        if (this.supportsAlpha()) {
            jCheckBoxMenuItem = new JCheckBoxMenuItem(I18N.gettext((String)"windowsutils.Make_transparent"));
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBoxMenuItem)actionEvent.getSource()).isSelected()) {
                        util.setWindowAlpha(chatSplitPane.getTopLevelAncestor(), Preferences.getInteger((String)Plugin.NAME, (String)"alpha", (int)70));
                    } else {
                        util.setWindowAlpha(chatSplitPane.getTopLevelAncestor(), 100);
                    }
                }
            });
            jMenu.add(jCheckBoxMenuItem);
        }
    }

    public void flash(Component component, boolean bl) {
        util.flash(component, bl);
    }

    public void windowAlwaysOnTop(Component component, boolean bl) {
        util.windowAlwaysOnTop(component, bl);
    }

    public void setWindowAlpha(Component component, int n) {
        util.setWindowAlpha(component, n);
    }

    public void unload() {
    }

    public static void unload(Backend backend) {
        if (util != null) {
            backend.getMain().removeFromMenu(menuTransparent);
            backend.getMain().removeFromMenu(menuAlwaysOnTop);
        }
        util = null;
    }
}

