/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.spell;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryDichoDisk;
import com.swabunga.spell.engine.Word;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import nu.fw.jeti.backend.Start;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.plugins.Plugins;
import nu.fw.jeti.plugins.Spell;
import nu.fw.jeti.plugins.spell.JTextComponentSpellChecker;
import nu.fw.jeti.util.I18N;
import nu.fw.jeti.util.Popups;
import nu.fw.jeti.util.Preferences;

public class Plugin
implements Plugins,
Spell {
    public static final String VERSION = "0.2";
    public static final String DESCRIPTION = "spell.Spellcheck";
    public static final String MIN_JETI_VERSION = "0.5.1";
    public static final String NAME = "spell";
    public static final String ABOUT = "by E.S. de boer, uses Jazzy (jazzy.sourceforge.net)";
    private JTextComponentSpellChecker spellChecker;
    private static Map dictionaries = new HashMap(2);
    private static String[] availableLanguages = new String[0];
    private boolean disabled = false;

    public static void init(Backend backend) {
        Plugin.loadDictionaries();
        String string = Start.path + "dictionaries" + File.separator;
        for (int i = 0; i < availableLanguages.length; ++i) {
            Plugin.loadDictionary(string, availableLanguages[i], true);
        }
    }

    public Plugin() {
        if (dictionaries.isEmpty()) {
            this.disabled = true;
            return;
        }
        String string = Preferences.getString((String)NAME, (String)"defaultLanguage", null);
        SpellDictionary spellDictionary = (SpellDictionary)dictionaries.get(string);
        if (spellDictionary == null) {
            spellDictionary = (SpellDictionary)dictionaries.values().iterator().next();
        }
        this.spellChecker = new JTextComponentSpellChecker(spellDictionary);
    }

    public void addChangeDictoryMenuEntry(JMenu jMenu) {
        if (availableLanguages.length < 2) {
            return;
        }
        JMenu jMenu2 = new JMenu(I18N.gettext((String)"spell.Dictionary"));
        for (int i = 0; i < availableLanguages.length; ++i) {
            String string = availableLanguages[i].substring(0, availableLanguages[i].indexOf(46));
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.setActionCommand(availableLanguages[i]);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    Plugin.this.disabled = false;
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getText();
                    if (!dictionaries.containsKey(string)) {
                        object = Start.path + "dictionaries" + File.separator;
                        Plugin.loadDictionary((String)object, jMenuItem.getActionCommand(), false);
                    }
                    object = (SpellDictionary)dictionaries.get(string);
                    Plugin.this.spellChecker = new JTextComponentSpellChecker((SpellDictionary)object);
                }
            });
            jMenu2.add(jMenuItem);
        }
        JMenuItem jMenuItem = new JMenuItem(I18N.gettext((String)"spell.None"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Plugin.this.disabled = true;
            }
        });
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
    }

    public void unload() {
        this.spellChecker = null;
        dictionaries = null;
        System.out.println("unload spell");
    }

    public static String[] getLanguages() {
        return availableLanguages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDictionaries() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2 = Start.path + "dictionaries" + File.separator;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2 + "list.txt"));
            }
            catch (IOException iOException) {
                Plugin.scanDictionaries();
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                }
                return;
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
            }
            availableLanguages = linkedList.toArray(availableLanguages);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    protected static void scanDictionaries() {
        String string = Start.path + "dictionaries" + File.separator;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.err.println(I18N.gettext((String)"spell.dictionaries_dir_not_found"));
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + "list.txt"));
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string2 = file2.getName();
                if (!string2.endsWith(".dico")) continue;
                String string3 = string2.substring(0, string2.length() - 5);
                string3 = string3 + ".phon";
                if (new File(string + string3).exists()) {
                    bufferedWriter.write(string2 + " " + string3 + "\r\n");
                    linkedList.add(string2 + " " + string3);
                    continue;
                }
                bufferedWriter.write(string2 + "\r\n");
                linkedList.add(string2);
            }
            bufferedWriter.close();
            availableLanguages = linkedList.toArray(availableLanguages);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected static void unloadDictionary(String string) {
        dictionaries.remove(string);
    }

    protected static void loadDictionary(String string) {
        Plugin.loadDictionary(Start.path + "dictionaries" + File.separator, string, true);
    }

    private static void loadDictionary(String string, String string2, boolean bl) {
        try {
            File file = null;
            File file2 = null;
            String string3 = null;
            int n = string2.indexOf(32);
            if (n == -1) {
                string3 = string2;
            } else {
                string3 = string2.substring(0, n);
                file2 = new File(string + string2.substring(n + 1, string2.length()));
            }
            String string4 = string3.substring(0, string3.length() - 5);
            if (Preferences.getBoolean((String)NAME, (String)string4, (boolean)false) || !bl) {
                file = new File(string + string3);
                dictionaries.put(string4, new SpellDictionaryDichoDisk(file, file2));
            }
        }
        catch (IOException iOException) {
            Popups.errorPopup((String)iOException.getLocalizedMessage(), (String)I18N.gettext((String)"spell.Dictionary_not_found"));
        }
    }

    public boolean rightClick(JTextComponent jTextComponent, MouseEvent mouseEvent) {
        int n = jTextComponent.viewToModel(mouseEvent.getPoint());
        Highlighter.Highlight[] highlightArray = jTextComponent.getHighlighter().getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            Highlighter.Highlight highlight = highlightArray[i];
            if (n < highlight.getStartOffset() || n > highlight.getEndOffset()) continue;
            try {
                jTextComponent.getHighlighter().removeHighlight(highlight);
                String string = jTextComponent.getText(highlight.getStartOffset(), highlight.getEndOffset() - highlight.getStartOffset());
                this.correct(jTextComponent, string, highlight.getStartOffset()).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private JPopupMenu correct(final JTextComponent jTextComponent, final String string, final int n) {
        List list = this.spellChecker.getSuggestions(string);
        JPopupMenu jPopupMenu = new JPopupMenu();
        Object object = list.iterator();
        while (object.hasNext()) {
            final String string2 = ((Word)object.next()).toString();
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Document document = jTextComponent.getDocument();
                    try {
                        document.remove(n, string.length());
                        jTextComponent.getDocument().insertString(n, string2, null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            jPopupMenu.add(jMenuItem);
        }
        object = new JMenuItem(I18N.gettext((String)"spell.Ignore"), 73);
        jPopupMenu.add((JMenuItem)object);
        return jPopupMenu;
    }

    public void keyReleased(KeyEvent keyEvent, JTextComponent jTextComponent) {
        if (this.disabled) {
            return;
        }
        if (keyEvent.getKeyCode() == 32) {
            if (keyEvent.isControlDown() || keyEvent.isShiftDown()) {
                try {
                    int n = jTextComponent.getCaretPosition();
                    int n2 = Utilities.getWordStart(jTextComponent, n);
                    int n3 = Utilities.getWordEnd(jTextComponent, n);
                    String string = jTextComponent.getDocument().getText(n2, n3 - n2);
                    string = string.trim();
                    if (string.length() == 0) {
                        if (n == 0) {
                            return;
                        }
                        n2 = Utilities.getWordStart(jTextComponent, --n);
                        n3 = Utilities.getWordEnd(jTextComponent, n);
                        string = jTextComponent.getDocument().getText(n2, n3 - n2);
                    }
                    if (string.trim().length() == 0) {
                        return;
                    }
                    Rectangle rectangle = jTextComponent.modelToView(n3);
                    this.correct(jTextComponent, string, n2).show(jTextComponent, rectangle.x, rectangle.y);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else {
                this.spellChecker.spellCheck(jTextComponent);
                int n = jTextComponent.getCaretPosition();
                Highlighter.Highlight[] highlightArray = jTextComponent.getHighlighter().getHighlights();
                for (int i = 0; i < highlightArray.length; ++i) {
                    Highlighter.Highlight highlight = highlightArray[i];
                    if (n < highlight.getStartOffset() || n > highlight.getEndOffset()) continue;
                    jTextComponent.getHighlighter().removeHighlight(highlight);
                }
            }
        }
    }
}

