/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle.media;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleMediaListener;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleError;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MediaNegotiator
extends JingleNegotiator {
    private final JingleSession session;
    private final List<PayloadType> localAudioPts = new ArrayList<PayloadType>();
    private final List<PayloadType> remoteAudioPts = new ArrayList<PayloadType>();
    private PayloadType.Audio bestCommonAudioPt;
    private final Inviting inviting;
    private final Accepting accepting;
    private final Pending pending;
    private final Active active;

    public MediaNegotiator(JingleSession jingleSession, List<PayloadType> list) {
        super(jingleSession.getConnection());
        this.session = jingleSession;
        this.bestCommonAudioPt = null;
        if (list != null && list.size() > 0) {
            this.localAudioPts.addAll(list);
        }
        this.inviting = new Inviting(this);
        this.accepting = new Accepting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Jingle dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        Jingle jingle2 = null;
        if (this.invalidState()) {
            if (jingle == null) {
                this.setState(this.inviting);
                jingle2 = this.getState().eventInvite();
            } else {
                if (!(jingle instanceof Jingle)) throw new IllegalStateException("Invitation IQ received is not a Jingle packet in Media negotiator.");
                this.setState(this.accepting);
                jingle2 = this.getState().eventInitiate(jingle);
            }
        } else {
            Jingle jingle3;
            Jingle.Action action;
            if (jingle == null) {
                return null;
            }
            if (jingle.getType().equals("error")) {
                this.getState().eventError(jingle);
            } else if (jingle.getType().equals("result")) {
                System.out.println(new StringBuffer().append("trying to ack ").append(jingle.getPacketID()).toString());
                if (this.isExpectedId(jingle.getPacketID())) {
                    jingle2 = this.getState().eventAck(jingle);
                    this.removeExpectedId(jingle.getPacketID());
                }
            } else if (jingle instanceof Jingle && (action = (jingle3 = jingle).getAction()) != null) {
                if (action.equals((Object)Jingle.Action.CONTENTACCEPT)) {
                    jingle2 = this.getState().eventAccept(jingle3);
                } else if (action.equals((Object)Jingle.Action.CONTENTDECLINE)) {
                    jingle2 = this.getState().eventDecline(jingle3);
                } else if (action.equals((Object)Jingle.Action.DESCRIPTIONINFO)) {
                    jingle2 = this.getState().eventInfo(jingle3);
                } else if (action.equals((Object)Jingle.Action.CONTENTMODIFY)) {
                    jingle2 = this.getState().eventModify(jingle3);
                }
            }
        }
        if (string != null) {
            this.addExpectedId(string);
            return jingle2;
        } else {
            if (jingle2 == null) return jingle2;
            this.addExpectedId(jingle2.getPacketID());
        }
        return jingle2;
    }

    public boolean isEstablished() {
        return this.getBestCommonAudioPt() != null;
    }

    public boolean isFullyEstablished() {
        return this.isEstablished() && this.getState() == this.active;
    }

    private PayloadType.Audio calculateBestCommonAudioPt(List list) {
        ArrayList<PayloadType> arrayList = new ArrayList<PayloadType>();
        ArrayList arrayList2 = new ArrayList();
        PayloadType.Audio audio = null;
        if (!list.isEmpty()) {
            arrayList.addAll(this.localAudioPts);
            arrayList.retainAll(list);
            arrayList2.addAll(list);
            arrayList2.retainAll(this.localAudioPts);
            if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
                if (this.session.getInitiator().equals(this.session.getConnection().getMyJID())) {
                    PayloadType.Audio audio2 = null;
                    PayloadType payloadType = this.session.getMediaManager().getPreferredPayloadType();
                    if (payloadType != null && payloadType instanceof PayloadType.Audio && arrayList.contains(payloadType)) {
                        audio2 = (PayloadType.Audio)payloadType;
                    }
                    if (audio2 == null) {
                        for (PayloadType payloadType2 : arrayList) {
                            if (!(payloadType2 instanceof PayloadType.Audio)) continue;
                            audio2 = (PayloadType.Audio)payloadType2;
                            break;
                        }
                    }
                    audio = audio2;
                } else {
                    PayloadType.Audio audio3 = null;
                    for (PayloadType payloadType : arrayList2) {
                        if (!(payloadType instanceof PayloadType.Audio)) continue;
                        audio3 = (PayloadType.Audio)payloadType;
                        break;
                    }
                    audio = audio3;
                }
            }
        }
        return audio;
    }

    private List obtainPayloads(Jingle jingle) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = jingle.getDescriptions();
        while (iterator.hasNext()) {
            JingleContentDescription.Audio audio = (JingleContentDescription.Audio)((Object)iterator.next());
            if (audio == null) continue;
            arrayList.clear();
            arrayList.addAll(audio.getAudioPayloadTypesList());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteAudioPayloadType(PayloadType.Audio audio) {
        if (audio != null) {
            List<PayloadType> list = this.remoteAudioPts;
            synchronized (list) {
                this.remoteAudioPts.add(audio);
            }
        }
    }

    private Jingle getAudioPayloadTypesOffer() {
        JingleContentDescription.Audio audio = new JingleContentDescription.Audio();
        audio.addAudioPayloadTypes(this.localAudioPts);
        return new Jingle(audio);
    }

    private Jingle createAcceptMessage() {
        Jingle jingle = null;
        jingle = new Jingle(Jingle.Action.CONTENTACCEPT);
        jingle.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType.Audio(this.bestCommonAudioPt)));
        return jingle;
    }

    public PayloadType.Audio getBestCommonAudioPt() {
        return this.bestCommonAudioPt;
    }

    protected void triggerMediaEstablished(PayloadType payloadType) {
        ArrayList arrayList = this.getListenersList();
        for (JingleListener jingleListener : arrayList) {
            if (!(jingleListener instanceof JingleMediaListener)) continue;
            JingleMediaListener jingleMediaListener = (JingleMediaListener)jingleListener;
            jingleMediaListener.mediaEstablished(payloadType);
        }
    }

    protected void triggerMediaClosed(PayloadType payloadType) {
        ArrayList arrayList = this.getListenersList();
        for (JingleListener jingleListener : arrayList) {
            if (!(jingleListener instanceof JingleMediaListener)) continue;
            JingleMediaListener jingleMediaListener = (JingleMediaListener)jingleListener;
            jingleMediaListener.mediaClosed(payloadType);
        }
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    public IQExtension dispatchIncomingPacket(Jingle jingle, String string) throws XMPPException {
        return this.dispatchIncomingPacket(jingle, string);
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(MediaNegotiator mediaNegotiator2) {
            super(mediaNegotiator2);
        }

        public void eventEnter() {
            MediaNegotiator.this.triggerMediaEstablished(MediaNegotiator.this.getBestCommonAudioPt());
            System.err.println("BS:" + MediaNegotiator.this.getBestCommonAudioPt().getName());
            super.eventEnter();
        }

        public void eventExit() {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            super.eventExit();
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        public Pending(MediaNegotiator mediaNegotiator2) {
            super(mediaNegotiator2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Jingle eventInfo(Jingle jingle) throws JingleNegotiator.JingleException {
            PayloadType.Audio audio = MediaNegotiator.this.bestCommonAudioPt;
            Jingle jingle2 = null;
            boolean bl = false;
            List list = MediaNegotiator.this.obtainPayloads(jingle);
            if (!list.isEmpty()) {
                List list2 = MediaNegotiator.this.remoteAudioPts;
                synchronized (list2) {
                    MediaNegotiator.this.remoteAudioPts.clear();
                    MediaNegotiator.this.remoteAudioPts.addAll(list);
                }
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                if (MediaNegotiator.this.bestCommonAudioPt != null) {
                    boolean bl2 = bl = !MediaNegotiator.this.bestCommonAudioPt.equals(audio);
                    if (audio == null || bl) {
                        jingle2 = MediaNegotiator.this.createAcceptMessage();
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.NO_COMMON_PAYLOAD);
                }
            }
            return jingle2;
        }

        public Jingle eventAccept(Jingle jingle) throws JingleNegotiator.JingleException {
            List list = new ArrayList();
            Jingle jingle2 = null;
            if (MediaNegotiator.this.bestCommonAudioPt == null) {
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                jingle2 = MediaNegotiator.this.createAcceptMessage();
            }
            if (!(list = MediaNegotiator.this.obtainPayloads(jingle)).isEmpty()) {
                if (list.size() == 1) {
                    PayloadType.Audio audio = (PayloadType.Audio)list.get(0);
                    if (MediaNegotiator.this.bestCommonAudioPt != null && !audio.equals(MediaNegotiator.this.bestCommonAudioPt)) {
                        throw new JingleNegotiator.JingleException(JingleError.NEGOTIATION_ERROR);
                    }
                } else if (list.size() > 1) {
                    throw new JingleNegotiator.JingleException(JingleError.MALFORMED_STANZA);
                }
            }
            return jingle2;
        }

        public Jingle eventDecline(Jingle jingle) throws JingleNegotiator.JingleException {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            throw new JingleNegotiator.JingleException();
        }

        public void eventError(Jingle jingle) throws XMPPException {
            MediaNegotiator.this.triggerMediaClosed(MediaNegotiator.this.getBestCommonAudioPt());
            super.eventError(jingle);
        }

        public Jingle eventAck(Jingle jingle) {
            if (MediaNegotiator.this.isEstablished()) {
                MediaNegotiator.this.setState(MediaNegotiator.this.active);
                return null;
            }
            return null;
        }
    }

    public class Accepting
    extends JingleNegotiator.State {
        public Accepting(MediaNegotiator mediaNegotiator2) {
            super(mediaNegotiator2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Jingle eventInitiate(Jingle jingle) {
            List list = MediaNegotiator.this.remoteAudioPts;
            synchronized (list) {
                MediaNegotiator.this.remoteAudioPts.addAll(MediaNegotiator.this.obtainPayloads(jingle));
            }
            return MediaNegotiator.this.getAudioPayloadTypesOffer();
        }

        public Jingle eventAck(Jingle jingle) throws XMPPException {
            Jingle jingle2 = null;
            if (!MediaNegotiator.this.remoteAudioPts.isEmpty()) {
                MediaNegotiator.this.bestCommonAudioPt = MediaNegotiator.this.calculateBestCommonAudioPt(MediaNegotiator.this.remoteAudioPts);
                if (MediaNegotiator.this.bestCommonAudioPt == null) {
                    throw new JingleNegotiator.JingleException(JingleError.NO_COMMON_PAYLOAD);
                }
                jingle2 = MediaNegotiator.this.createAcceptMessage();
                MediaNegotiator.this.setState(MediaNegotiator.this.pending);
            }
            return jingle2;
        }
    }

    public class Inviting
    extends JingleNegotiator.State {
        public Inviting(MediaNegotiator mediaNegotiator2) {
            super(mediaNegotiator2);
        }

        public Jingle eventInvite() {
            return MediaNegotiator.this.getAudioPayloadTypesOffer();
        }

        public Jingle eventAck(Jingle jingle) {
            MediaNegotiator.this.setState(MediaNegotiator.this.pending);
            return null;
        }
    }
}

