/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.jingle.jingle;

import java.util.List;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.plugins.jingle.XMPPException;
import nu.fw.jeti.plugins.jingle.jingle.JingleNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.JingleSession;
import nu.fw.jeti.plugins.jingle.jingle.JingleSessionRequest;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleMediaListener;
import nu.fw.jeti.plugins.jingle.jingle.listeners.JingleTransportListener;
import nu.fw.jeti.plugins.jingle.jingle.media.JingleMediaManager;
import nu.fw.jeti.plugins.jingle.jingle.media.MediaNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.media.PayloadType;
import nu.fw.jeti.plugins.jingle.jingle.nat.JingleTransportManager;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportCandidate;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportNegotiator;
import nu.fw.jeti.plugins.jingle.jingle.nat.TransportResolver;
import nu.fw.jeti.plugins.jingle.packet.Jingle;
import nu.fw.jeti.plugins.jingle.packet.JingleContentDescription;
import nu.fw.jeti.plugins.jingle.packet.JingleError;

public class OutgoingJingleSession
extends JingleSession {
    private final Inviting inviting;
    private final Pending pending;
    private final Active active;

    protected OutgoingJingleSession(Backend backend, JID jID, List list, JingleTransportManager jingleTransportManager) {
        super(backend, backend.getMyJID(), jID);
        this.setSid(OutgoingJingleSession.generateSessionId());
        this.inviting = new Inviting(this);
        this.pending = new Pending(this);
        this.active = new Active(this);
        TransportResolver transportResolver = null;
        transportResolver = jingleTransportManager.getResolver(this);
        this.setMediaNeg(new MediaNegotiator(this, list));
        if (transportResolver.getType().equals((Object)TransportResolver.Type.rawupd)) {
            this.setTransportNeg(new TransportNegotiator.RawUdp(this, transportResolver));
        }
        if (transportResolver.getType().equals((Object)TransportResolver.Type.ice)) {
            this.setTransportNeg(new TransportNegotiator.Ice(this, transportResolver));
        }
    }

    protected OutgoingJingleSession(Backend backend, JID jID, List list, JingleTransportManager jingleTransportManager, JingleMediaManager jingleMediaManager) {
        this(backend, jID, list, jingleTransportManager);
        this.jingleMediaManager = jingleMediaManager;
    }

    public void start(JingleSessionRequest jingleSessionRequest) throws IllegalStateException {
        if (this.invalidState()) {
            this.setState(this.inviting);
            try {
                this.respond(null);
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
                this.close();
            }
        } else {
            throw new IllegalStateException("Starting session without null state.");
        }
    }

    public void start() throws IllegalStateException {
        this.start(null);
    }

    public class Active
    extends JingleNegotiator.State {
        public Active(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
        }

        public void eventEnter() {
            PayloadType.Audio audio = OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
            TransportCandidate transportCandidate = OutgoingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
            TransportCandidate transportCandidate2 = OutgoingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate();
            OutgoingJingleSession.this.triggerSessionEstablished(audio, transportCandidate, transportCandidate2);
            super.eventEnter();
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }

        public void eventError(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosedOnError(new XMPPException(jingle.getError().getFirstXMPPError().getError()));
            super.eventError(jingle);
        }
    }

    public class Pending
    extends JingleNegotiator.State {
        JingleMediaListener jingleMediaListener;
        JingleTransportListener jingleTransportListener;

        public Pending(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
            this.jingleMediaListener = new JingleMediaListener(){

                public void mediaClosed(PayloadType payloadType) {
                }

                public void mediaEstablished(PayloadType payloadType) {
                    Pending.this.checkFullyEstablished();
                }
            };
            this.jingleTransportListener = new JingleTransportListener(){

                public void transportEstablished(TransportCandidate transportCandidate, TransportCandidate transportCandidate2) {
                    Pending.this.checkFullyEstablished();
                }

                public void transportClosed(TransportCandidate transportCandidate) {
                }

                public void transportClosedOnError(XMPPException xMPPException) {
                }
            };
        }

        public void eventEnter() {
            OutgoingJingleSession.this.addMediaListener(this.jingleMediaListener);
            OutgoingJingleSession.this.addTransportListener(this.jingleTransportListener);
        }

        public void eventExit() {
            OutgoingJingleSession.this.removeMediaListener(this.jingleMediaListener);
            OutgoingJingleSession.this.removeTransportListener(this.jingleTransportListener);
        }

        private void checkFullyEstablished() {
            if (OutgoingJingleSession.this.isFullyEstablished()) {
                PayloadType.Audio audio = OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt();
                TransportCandidate transportCandidate = OutgoingJingleSession.this.getTransportNeg().getBestRemoteCandidate();
                Jingle jingle = new Jingle(Jingle.Action.SESSIONACCEPT);
                jingle.addDescription(new JingleContentDescription.Audio(new JingleContentDescription.JinglePayloadType(audio)));
                jingle.addTransport(OutgoingJingleSession.this.getTransportNeg().getJingleTransport(transportCandidate));
                OutgoingJingleSession.this.addExpectedId(jingle.getPacketID());
                OutgoingJingleSession.this.sendFormattedJingle(jingle);
            }
        }

        public Jingle eventAccept(Jingle jingle) throws XMPPException {
            PayloadType.Audio audio = null;
            TransportCandidate transportCandidate = null;
            if (OutgoingJingleSession.this.isFullyEstablished()) {
                audio = OutgoingJingleSession.this.getAcceptedAudioPayloadType(jingle);
                transportCandidate = OutgoingJingleSession.this.getAcceptedLocalCandidate(jingle);
                if (audio != null && transportCandidate != null) {
                    if (((PayloadType)audio).equals(OutgoingJingleSession.this.getMediaNeg().getBestCommonAudioPt()) && transportCandidate.equals(OutgoingJingleSession.this.getTransportNeg().getAcceptedLocalCandidate())) {
                        OutgoingJingleSession.this.setState(OutgoingJingleSession.this.active);
                    }
                } else {
                    throw new JingleNegotiator.JingleException(JingleError.NEGOTIATION_ERROR);
                }
            }
            return null;
        }

        public Jingle eventAck(Jingle jingle) {
            OutgoingJingleSession.this.setState(OutgoingJingleSession.this.active);
            return null;
        }

        public Jingle eventRedirect(Jingle jingle) {
            String string = null;
            OutgoingJingleSession.this.triggerSessionRedirect(string);
            return null;
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }

        public void eventError(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosedOnError(new XMPPException(jingle.getError().getFirstXMPPError().getError()));
            super.eventError(jingle);
        }
    }

    public class Inviting
    extends JingleNegotiator.State {
        public Inviting(JingleNegotiator jingleNegotiator) {
            super(jingleNegotiator);
        }

        public Jingle eventInvite() {
            return new Jingle(Jingle.Action.SESSIONINITIATE);
        }

        public Jingle eventAck(Jingle jingle) {
            OutgoingJingleSession.this.setState(OutgoingJingleSession.this.pending);
            return null;
        }

        public void eventError(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionDeclined(null);
            super.eventError(jingle);
        }

        public Jingle eventRedirect(Jingle jingle) {
            String string = null;
            OutgoingJingleSession.this.triggerSessionRedirect(string);
            return null;
        }

        public Jingle eventTerminate(Jingle jingle) throws XMPPException {
            OutgoingJingleSession.this.triggerSessionClosed("Closed Remotely");
            return super.eventTerminate(jingle);
        }
    }
}

