/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.util.Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectivityCheck {
    private static final int LOCAL_PREFERENCE = 0;
    private static final int SERVER_REFLEXIVE_PREFERENCE = 42;
    private static final int PEER_REFLEXIVE_PREFERENCE = 84;
    private static final int RELAYED_PREFERENCE = 126;
    private short componentId;
    HashSet candidates;

    public ConnectivityCheck(short s) {
        this.componentId = s;
        this.candidates = new HashSet();
    }

    public void gatherCandidateAddresses() {
        int n = 0;
        this.candidates = new HashSet();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    Candidate candidate = new Candidate(new Address(inetAddress.getAddress()), this.componentId, n++);
                    this.candidates.add(candidate);
                    DiscoveryTest discoveryTest = new DiscoveryTest(inetAddress, "127.0.0.1", 5036);
                    DiscoveryInfo discoveryInfo = discoveryTest.test();
                    if (discoveryInfo.getPublicIP() == null) continue;
                    Candidate candidate2 = new Candidate(new Address(discoveryInfo.getPublicIP().getAddress()), Candidate.CandidateType.ServerReflexive, this.componentId, candidate, n++);
                    candidate2.setComponentId(this.componentId);
                    this.candidates.add(candidate2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void prioritizeCandidates() {
        Candidate candidate;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = this.candidates.iterator();
        while (iterator.hasNext()) {
            candidate = (Candidate)iterator.next();
            Candidate.CandidateType candidateType = candidate.getCandidateType();
            if (candidateType == Candidate.CandidateType.Local) {
                ++n;
                continue;
            }
            if (candidateType == Candidate.CandidateType.ServerReflexive) {
                ++n2;
                continue;
            }
            if (candidateType == Candidate.CandidateType.PeerReflexive) {
                ++n3;
                continue;
            }
            if (candidateType != Candidate.CandidateType.Relayed) continue;
            ++n4;
        }
        iterator = this.candidates.iterator();
        while (iterator.hasNext()) {
            int n5 = 0;
            int n6 = 0;
            short s = 0;
            candidate = (Candidate)iterator.next();
            Candidate.CandidateType candidateType = candidate.getCandidateType();
            if (candidateType == Candidate.CandidateType.Local) {
                n5 = 0;
                n6 = n--;
            } else if (candidateType == Candidate.CandidateType.ServerReflexive) {
                n5 = 42;
                n6 = n2--;
            } else if (candidateType == Candidate.CandidateType.PeerReflexive) {
                n5 = 84;
                n6 = n3--;
            } else if (candidateType == Candidate.CandidateType.Relayed) {
                n5 = 126;
                n6 = n4--;
            }
            s = candidate.getComponentId();
            int n7 = 26 * n5 + 10 * n6 + s;
            candidate.setPriority(n7);
        }
    }

    public static void main(String[] stringArray) {
        ConnectivityCheck connectivityCheck = new ConnectivityCheck(1);
        connectivityCheck.gatherCandidateAddresses();
    }
}

