/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo;

import de.javawi.jstun.test.DiscoveryTest;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class DiscoveryTestDemo
implements Runnable {
    InetAddress iaddress;

    public DiscoveryTestDemo(InetAddress inetAddress) {
        this.iaddress = inetAddress;
    }

    public void run() {
        try {
            DiscoveryTest discoveryTest = new DiscoveryTest(this.iaddress, "stun.xten.net", 3478);
            System.out.println(discoveryTest.test());
        }
        catch (BindException bindException) {
            System.out.println(this.iaddress.toString() + ": " + bindException.getMessage());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            FileHandler fileHandler = new FileHandler("logging.txt");
            fileHandler.setFormatter(new SimpleFormatter());
            Logger.getLogger("de.javawi.stun").addHandler(fileHandler);
            Logger.getLogger("de.javawi.stun").setLevel(Level.ALL);
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    Thread thread = new Thread(new DiscoveryTestDemo(inetAddress));
                    thread.start();
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

