/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.ErrorCode;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MappedResponseChangedSourceAddressReflectedFrom;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class DiscoveryTest {
    private static Logger logger = Logger.getLogger("de.javawi.stun.test.DiscoveryTest");
    InetAddress iaddress;
    String stunServer;
    int port;
    int timeoutInitValue = 300;
    MappedAddress ma = null;
    ChangedAddress ca = null;
    boolean nodeNatted = true;
    DatagramSocket socketTest1 = null;
    DiscoveryInfo di = null;

    public DiscoveryTest(InetAddress inetAddress, String string, int n) {
        this.iaddress = inetAddress;
        this.stunServer = string;
        this.port = n;
    }

    public DiscoveryInfo test() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        this.ma = null;
        this.ca = null;
        this.nodeNatted = true;
        this.socketTest1 = null;
        this.di = new DiscoveryInfo(this.iaddress);
        if (this.test1() && this.test2() && this.test1Redo()) {
            this.test3();
        }
        this.socketTest1.close();
        return this.di;
    }

    public DiscoveryInfo quickTest() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        this.ma = null;
        this.ca = null;
        this.nodeNatted = true;
        this.socketTest1 = null;
        this.di = new DiscoveryInfo(this.iaddress);
        this.test1();
        this.socketTest1.close();
        return this.di;
    }

    private boolean test1() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int n = 0;
        int n2 = this.timeoutInitValue;
        while (true) {
            try {
                Object object;
                this.socketTest1 = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                this.socketTest1.setReuseAddress(true);
                this.socketTest1.connect(InetAddress.getByName(this.stunServer), this.port);
                this.socketTest1.setSoTimeout(n2);
                MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                messageHeader.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                messageHeader.addMessageAttribute(changeRequest);
                byte[] byArray = messageHeader.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.socketTest1.send(datagramPacket);
                logger.finer("Test 1: Binding Request sent.");
                MessageHeader messageHeader2 = new MessageHeader();
                while (!messageHeader2.equalTransactionID(messageHeader)) {
                    object = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive((DatagramPacket)object);
                    messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
                }
                this.ma = (MappedAddress)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                this.ca = (ChangedAddress)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangedAddress);
                object = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (object != null) {
                    this.di.setError(((ErrorCode)object).getResponseCode(), ((ErrorCode)object).getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (this.ma == null || this.ca == null) {
                    this.di.setError(700, "The server is sending incomplete response (Mapped Address and Changed Address message attributes are missing). The client should not retry.");
                    logger.config("Response does not contain a mapped address or changed address message attribute.");
                    return false;
                }
                this.di.setPublicIP(this.ma.getAddress().getInetAddress());
                if (this.ma.getPort() == this.socketTest1.getLocalPort() && this.ma.getAddress().getInetAddress().equals(this.socketTest1.getLocalAddress())) {
                    logger.fine("Node is not natted.");
                    this.nodeNatted = false;
                } else {
                    logger.fine("Node is natted.");
                }
                return true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n < 7900) {
                    logger.finer("Test 1: Socket timeout while receiving the response.");
                    int n3 = (n += n2) * 2;
                    if (n3 > 1600) {
                        n3 = 1600;
                    }
                    n2 = n3;
                    continue;
                }
                logger.finer("Test 1: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                this.di.setBlockedUDP();
                logger.fine("Node is not capable of udp communication.");
                return false;
            }
            break;
        }
    }

    private boolean test2() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int n = 0;
        int n2 = this.timeoutInitValue;
        while (true) {
            try {
                Object object;
                DatagramSocket datagramSocket = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                datagramSocket.connect(InetAddress.getByName(this.stunServer), this.port);
                datagramSocket.setSoTimeout(n2);
                MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                messageHeader.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                changeRequest.setChangeIP();
                changeRequest.setChangePort();
                messageHeader.addMessageAttribute(changeRequest);
                byte[] byArray = messageHeader.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                datagramSocket.send(datagramPacket);
                logger.finer("Test 2: Binding Request sent.");
                int n3 = datagramSocket.getLocalPort();
                InetAddress inetAddress = datagramSocket.getLocalAddress();
                datagramSocket.close();
                DatagramSocket datagramSocket2 = new DatagramSocket(n3, inetAddress);
                datagramSocket2.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                datagramSocket2.setSoTimeout(n2);
                MessageHeader messageHeader2 = new MessageHeader();
                while (!messageHeader2.equalTransactionID(messageHeader)) {
                    object = new DatagramPacket(new byte[200], 200);
                    datagramSocket2.receive((DatagramPacket)object);
                    messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
                }
                object = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (object != null) {
                    this.di.setError(((ErrorCode)object).getResponseCode(), ((ErrorCode)object).getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (!this.nodeNatted) {
                    this.di.setOpenAccess();
                    logger.fine("Node has open access to the internet (or, at least the node is a full-cone NAT without translation).");
                } else {
                    this.di.setFullCone();
                    logger.fine("Node is behind a full-cone NAT.");
                }
                return false;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n < 7900) {
                    logger.finer("Test 2: Socket timeout while receiving the response.");
                    int n4 = (n += n2) * 2;
                    if (n4 > 1600) {
                        n4 = 1600;
                    }
                    n2 = n4;
                    continue;
                }
                logger.finer("Test 2: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                if (!this.nodeNatted) {
                    this.di.setSymmetricUDPFirewall();
                    logger.fine("Node is behind a symmetric udp firewall.");
                    return false;
                }
                return true;
            }
            break;
        }
    }

    private boolean test1Redo() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int n = 0;
        int n2 = this.timeoutInitValue;
        while (true) {
            try {
                Object object;
                this.socketTest1.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                this.socketTest1.setSoTimeout(n2);
                MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                messageHeader.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                messageHeader.addMessageAttribute(changeRequest);
                byte[] byArray = messageHeader.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.socketTest1.send(datagramPacket);
                logger.finer("Test 1 redo with changed address: Binding Request sent.");
                MessageHeader messageHeader2 = new MessageHeader();
                while (!messageHeader2.equalTransactionID(messageHeader)) {
                    object = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive((DatagramPacket)object);
                    messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
                }
                object = (MappedAddress)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                ErrorCode errorCode = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (errorCode != null) {
                    this.di.setError(errorCode.getResponseCode(), errorCode.getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (object == null) {
                    this.di.setError(700, "The server is sending incomplete response (Mapped Address message attribute is missing). The client should not retry.");
                    logger.config("Response does not contain a mapped address message attribute.");
                    return false;
                }
                if (this.ma.getPort() != ((MappedResponseChangedSourceAddressReflectedFrom)object).getPort() || !this.ma.getAddress().getInetAddress().equals(((MappedResponseChangedSourceAddressReflectedFrom)object).getAddress().getInetAddress())) {
                    this.di.setSymmetricCone();
                    logger.fine("Node is behind a symmetric NAT.");
                    return false;
                }
                return true;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n < 7900) {
                    logger.config("Test 1 redo with changed address: Socket timeout while receiving the response.");
                    int n3 = (n += n2) * 2;
                    if (n3 > 1600) {
                        n3 = 1600;
                    }
                    n2 = n3;
                    continue;
                }
                logger.config("Test 1 redo with changed address: Socket timeout while receiving the response.  Maximum retry limit exceed. Give up.");
                return false;
            }
            break;
        }
    }

    private void test3() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int n = 0;
        int n2 = this.timeoutInitValue;
        while (true) {
            try {
                while (true) {
                    Object object;
                    DatagramSocket datagramSocket = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                    datagramSocket.connect(InetAddress.getByName(this.stunServer), this.port);
                    datagramSocket.setSoTimeout(n2);
                    MessageHeader messageHeader = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                    messageHeader.generateTransactionID();
                    ChangeRequest changeRequest = new ChangeRequest();
                    changeRequest.setChangePort();
                    messageHeader.addMessageAttribute(changeRequest);
                    byte[] byArray = messageHeader.getBytes();
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    datagramSocket.send(datagramPacket);
                    logger.finer("Test 3: Binding Request sent.");
                    int n3 = datagramSocket.getLocalPort();
                    InetAddress inetAddress = datagramSocket.getLocalAddress();
                    datagramSocket.close();
                    DatagramSocket datagramSocket2 = new DatagramSocket(n3, inetAddress);
                    datagramSocket2.connect(InetAddress.getByName(this.stunServer), this.ca.getPort());
                    datagramSocket2.setSoTimeout(n2);
                    MessageHeader messageHeader2 = new MessageHeader();
                    while (!messageHeader2.equalTransactionID(messageHeader)) {
                        object = new DatagramPacket(new byte[200], 200);
                        datagramSocket2.receive((DatagramPacket)object);
                        messageHeader2 = MessageHeader.parseHeader(((DatagramPacket)object).getData());
                    }
                    object = (ErrorCode)messageHeader2.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                    if (object != null) {
                        this.di.setError(((ErrorCode)object).getResponseCode(), ((ErrorCode)object).getReason());
                        logger.config("Message header contains errorcode message attribute.");
                        return;
                    }
                    if (!this.nodeNatted) continue;
                    this.di.setRestrictedCone();
                    logger.fine("Node is behind a restricted NAT.");
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n < 7900) {
                    logger.finer("Test 3: Socket timeout while receiving the response.");
                    int n4 = (n += n2) * 2;
                    if (n4 > 1600) {
                        n4 = 1600;
                    }
                    n2 = n4;
                    continue;
                }
                logger.finer("Test 3: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                this.di.setPortRestrictedCone();
                logger.fine("Node is behind a port restricted NAT.");
                return;
            }
            break;
        }
    }
}

