/*
 * Decompiled with CFR 0.152.
 */
package nu.fw.jeti.plugins.vcard;

import java.util.List;
import java.util.Map;
import nu.fw.jeti.jabber.Backend;
import nu.fw.jeti.jabber.JID;
import nu.fw.jeti.jabber.JIDStatus;
import nu.fw.jeti.jabber.elements.Extension;
import nu.fw.jeti.jabber.elements.IQExtension;
import nu.fw.jeti.jabber.elements.InfoQuery;
import nu.fw.jeti.plugins.vcard.VCardDisplay;
import nu.fw.jeti.plugins.vcard.VCardEdit;

public class VCard
extends Extension
implements IQExtension {
    private Map personal;
    private Map business;
    private List homeTels;
    private List workTels;

    public VCard() {
    }

    public VCard(Map map, Map map2, List list, List list2) {
        this.personal = map;
        this.business = map2;
        this.homeTels = list;
        this.workTels = list2;
    }

    public void execute(InfoQuery infoQuery, Backend backend) {
        if (infoQuery.getType().equals("result")) {
            JID jID = infoQuery.getFrom();
            if (jID.equals(backend.getMyJID())) {
                new VCardEdit(this.personal, this.business, this.homeTels, this.workTels, backend);
            } else {
                JIDStatus jIDStatus = Backend.getJIDStatus((JID)jID);
                String string = jIDStatus != null ? jIDStatus.getNick() : jID.toStringNoResource();
                new VCardDisplay(this.personal, this.business, this.homeTels, this.workTels, string);
            }
        } else if (infoQuery.getType().equals("error")) {
            System.err.println(infoQuery.getErrorDescription());
        }
    }

    public String getPhoto() {
        String[] stringArray = (String[])this.personal.get("PHOTO");
        if (stringArray != null) {
            return stringArray[1];
        }
        return null;
    }

    public void appendToXML(StringBuffer stringBuffer) {
        if (this.personal == null) {
            stringBuffer.append("<vCard xmlns='vcard-temp'/>");
            return;
        }
        stringBuffer.append("<vCard xmlns='vcard-temp'>");
        this.appendPersonal(stringBuffer);
        this.appendBusiness(stringBuffer);
        stringBuffer.append("</vCard>");
    }

    private void appendPersonal(StringBuffer stringBuffer) {
        String[] stringArray;
        this.appendPersonalX(stringBuffer, "FN");
        stringBuffer.append("<N>");
        this.appendPersonalX(stringBuffer, "FAMILY");
        this.appendPersonalX(stringBuffer, "GIVEN");
        this.appendPersonalX(stringBuffer, "MIDDLE");
        stringBuffer.append("</N>");
        this.appendPersonalX(stringBuffer, "NICKNAME");
        this.appendPersonalX(stringBuffer, "BDAY");
        this.appendPersonalX(stringBuffer, "JABBERID");
        if (this.personal.get("LON") != null) {
            stringBuffer.append("<GEO>");
            this.appendPersonalX(stringBuffer, "LAT");
            this.appendPersonalX(stringBuffer, "LON");
            stringBuffer.append("</GEO>");
        }
        if ((stringArray = (String[])this.personal.get("PHOTO")) != null) {
            stringBuffer.append("<PHOTO>");
            VCard.appendAttribute((StringBuffer)stringBuffer, (String)"VALUE", (String)stringArray[0]);
            VCard.appendElement((StringBuffer)stringBuffer, (String)"BINVAL", (String)stringArray[1]);
            stringBuffer.append("</PHOTO>");
        }
        stringBuffer.append("<ADR>");
        stringBuffer.append("<HOME/>");
        this.appendPersonalX(stringBuffer, "POBOX");
        this.appendPersonalX(stringBuffer, "EXTADR");
        this.appendPersonalX(stringBuffer, "STREET");
        this.appendPersonalX(stringBuffer, "LOCALITY");
        this.appendPersonalX(stringBuffer, "REGION");
        this.appendPersonalX(stringBuffer, "PCODE");
        this.appendPersonalX(stringBuffer, "CTRY");
        stringBuffer.append("</ADR>");
        String string = (String)this.personal.get("EMAIL");
        if (string != null) {
            stringBuffer.append("<EMAIL>");
            stringBuffer.append("<HOME/>");
            VCard.appendElement((StringBuffer)stringBuffer, (String)"USERID", (String)string);
            stringBuffer.append("</EMAIL>");
        }
        this.appendPersonalX(stringBuffer, "URL");
        this.appendPersonalX(stringBuffer, "DESC");
    }

    private void appendPersonalX(StringBuffer stringBuffer, String string) {
        VCard.appendElement((StringBuffer)stringBuffer, (String)string, this.personal.get(string));
    }

    private void appendBusiness(StringBuffer stringBuffer) {
        this.appendBusinessX(stringBuffer, "TITLE");
        this.appendBusinessX(stringBuffer, "ROLE");
        this.appendBusinessX(stringBuffer, "ORGNAME");
        this.appendBusinessX(stringBuffer, "ORGUNIT");
        String[] stringArray = (String[])this.business.get("LOGO");
        if (stringArray != null) {
            stringBuffer.append("<LOGO>");
            VCard.appendAttribute((StringBuffer)stringBuffer, (String)"VALUE", (String)stringArray[0]);
            VCard.appendElement((StringBuffer)stringBuffer, (String)"BINVAL", (String)stringArray[1]);
            stringBuffer.append("</LOGO>");
        }
        stringBuffer.append("<ADR>");
        stringBuffer.append("<WORK/>");
        this.appendBusinessX(stringBuffer, "POBOX");
        this.appendBusinessX(stringBuffer, "EXTADR");
        this.appendBusinessX(stringBuffer, "STREET");
        this.appendBusinessX(stringBuffer, "LOCALITY");
        this.appendBusinessX(stringBuffer, "REGION");
        this.appendBusinessX(stringBuffer, "PCODE");
        this.appendBusinessX(stringBuffer, "CTRY");
        stringBuffer.append("</ADR>");
        String string = (String)this.business.get("EMAIL");
        if (string != null) {
            stringBuffer.append("<EMAIL>");
            stringBuffer.append("<WORK/>");
            VCard.appendElement((StringBuffer)stringBuffer, (String)"USERID", (String)string);
            stringBuffer.append("</EMAIL>");
        }
    }

    private void appendBusinessX(StringBuffer stringBuffer, String string) {
        VCard.appendElement((StringBuffer)stringBuffer, (String)string, this.business.get(string));
    }
}

